﻿using System;
using System.Threading;
using Microsoft.SPOT;
using Microsoft.SPOT.Hardware;
using SecretLabs.NETMF.Hardware.NetduinoPlus;

using Microtoolskit.Hardware.Sensors;
using Microtoolskit.Hardware.Displays;

namespace Incubateur
{
    public class Program
    {
        public static void Main()
        {
            // Variables
            var temperature = 0.0; // <- A compléter

            // Création des objets virtuels  
            TMP102 ModuleMesureTemp = new TMP102();    // <- Objet ModuleMesureTemp à créer
            ELCD162 Lcd = new ELCD162();

            // Initialisations
            ModuleMesureTemp.Init();
            Lcd.Init(); // COM2
            Lcd.ClearScreen(); Lcd.CursorOff();


            while (true)
            {
                // Lire la température
                temperature = ModuleMesureTemp.ReadAsCelcius(); // <- A compléter

                // Effacer le lcd
                Lcd.ClearScreen(); // <- A compléter


                // Afficher la température sur le lcd
                Lcd.PutString("T = " + temperature.ToString("F1") + "C"); // <- A compléter

                Thread.Sleep(1000); // Attendre une seconde entre chaque mesure
            }
        }
    }
}
