﻿using System;
using System.Threading;
using Microsoft.SPOT;
using Microsoft.SPOT.Hardware;
using SecretLabs.NETMF.Hardware.NetduinoPlus;
using ELCD162;

namespace Dosimetre
{
    public class Program
    {
        public static void Main()
        {   // Faire suivre les nombres réels de la lettre F
            // Formatage du texte pour affichage sur le LCD
            // http://msdn.microsoft.com/en-us/library/dwhawy9k(v=vs.110).aspx
            // Constantes
            const Single kma = 0.02301897f, kva = 0.00007812f, ku = 3.6f;
            const UInt16 delay = 1000;

            // Variables
            var Nma = 0;
            var Nva = 0;
            var M1 = 0.0;
            var V1 = 0.0;
            var qm = 0.0;

            // Configuration des entrées / sorties 
            //Entrées
            // http://msdn.microsoft.com/en-us/library/hh421132.aspx (description de la classe AnalogInput)
            AnalogInput masse = new AnalogInput(Cpu.AnalogChannel.ANALOG_0); // Potentiomètres sur I0 et I1 de la carte
            AnalogInput vitesse = new AnalogInput(Cpu.AnalogChannel.ANALOG_1); // Tinkerkit
            //Sortie
            OutputPort Alarme = new OutputPort(Pins.GPIO_PIN_D11, false); // (LED à connecter sur O0 de la carte Tinkerkit)
            // http://webge.github.io/ELCD162/ (description de la classe ELCD162)
            SerialELCD162 LCD = new SerialELCD162(); // (LCD à connecter sur O5 de la carte Tinkerkit)
            
            LCD.Init(); LCD.ClearScreen();

            while (true)
            {
                // Lire
                Nma = masse.ReadRaw();
                Nva = vitesse.ReadRaw();

                // Traiter
                M1 = kma * Nma;
                V1 = kva * Nva;
                qm = ku * kma * Nma * kva * Nva;

                // Ecrire
                Debug.Print("Nma= " + Nma.ToString() + "     Nva= " + Nva.ToString());
                Debug.Print("Masse = " + M1.ToString() + "      Vitesse =" + V1.ToString() + "      qm = " + qm.ToString());
                LCD.ClearScreen();
                LCD.PutString("M=" + M1.ToString("N0") + "kg/m" + " q=" + qm.ToString("N0") + "T/h");
                LCD.SetCursor(0, 1);
                LCD.PutString("v=" + V1.ToString("N3") + "m/s");
                if (qm > 80)
                {
                    Alarme.Write(true);
                }
                else if (qm < 79)
                {
                    Alarme.Write(false);
                }
               
                Thread.Sleep(delay);
            }
        }

    }
}
